package gov.va.med.mhv.vitals.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.converter.BloodSugarConverter;
import gov.va.med.mhv.vitals.dto.BloodSugarReadingDTO;
import gov.va.med.mhv.vitals.model.BloodSugarReading;
import gov.va.med.mhv.vitals.repository.BloodSugarReadingRepository;
import gov.va.med.mhv.vitals.service.BloodSugarService;
import gov.va.med.mhv.vitals.validator.BloodSugarValidator;

@Component
public class BloodSugarServiceImpl implements BloodSugarService {
	
	private static Logger log = LogManager.getLogger(BloodSugarServiceImpl.class);
	
	@Autowired
	private BloodSugarReadingRepository bsRepository;
	
	@Autowired
	private BloodSugarValidator validator;

	@Override
	public ResponseUtil<Long> save(BloodSugarReadingDTO bloodSugarDTO) {
		ResponseUtil<Long> response = new ResponseUtil<Long>();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.bloodSugarValidations(response, bloodSugarDTO);
		if(response.getValidationErrors().size() == 0){
			BloodSugarReading bsReading = BloodSugarConverter.convertBloodSugarReadingDTO(bloodSugarDTO);
			bsReading = bsRepository.save(bsReading);
			response.setSuccess(true);
			response.setPojoObject(bsReading.getId());
		}else{
			log.debug("Validation Errors in Blood Sugar  reading:");
			response.setFailure(true);
		}
		return response;
	}

	@Override
	public ResponseUtil delete(Long id) {
		ResponseUtil response = new ResponseUtil();
		bsRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		BloodSugarReading bsReading = bsRepository.findOne(id);
		if(bsReading != null){
			BloodSugarReadingDTO bsReadingDTO = BloodSugarConverter.convertBloodSugarReadingDomain(bsReading);
			response.setPojoObject(bsReadingDTO);
			response.setSuccess(true);
		}else{
			log.debug("Blood Sugar Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil<List<BloodSugarReadingDTO>> getBloodSugarReadingsForUser(Long userprofileid) {
		ResponseUtil<List<BloodSugarReadingDTO>> response = new ResponseUtil<List<BloodSugarReadingDTO>>();
		List<BloodSugarReading> bsReadings=bsRepository.getBloodSugarReadingsForUser(userprofileid);
		if(bsReadings != null){
			List<BloodSugarReadingDTO> dtos = BloodSugarConverter.convertBloodSugarReadings(bsReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Blood Sugar Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<List<BloodSugarReadingDTO>> getBloodSugarDashBoardReadingsForUser(Long userprofileid) {
		ResponseUtil<List<BloodSugarReadingDTO>> response = new ResponseUtil<List<BloodSugarReadingDTO>>();
		Pageable topFive = new  PageRequest(0,5);
		List<BloodSugarReading> bsReadings=bsRepository.getDashBoardBloodSugarReadingsForUser(userprofileid,topFive);
		if(bsReadings != null){
			List<BloodSugarReadingDTO> dtos = BloodSugarConverter.convertBloodSugarReadings(bsReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Blood Sugar dashboard Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<BloodSugarReadingDTO> getBloodSugarReadingByid(Long userProfileId, Long id) {
		ResponseUtil<BloodSugarReadingDTO> response = new ResponseUtil<BloodSugarReadingDTO>();
		BloodSugarReading bsReading = bsRepository.findOne(id);
		if(bsReading != null){
			BloodSugarReadingDTO dto=BloodSugarConverter.convertBloodSugarReadingDomain(bsReading);
			response.setPojoObject(dto);
		}else{
			log.debug("Blood Sugar Record not found for Id:");
			log.debug(id);
		}
		response.setSuccess(true);
		return response;
	}
}
